
*============================================================================
*Data Merging
*============================================================================

clear
set more off

*Pew Religious Composition
import excel "Datasets\Pew Religious Composition - to compare SRI.xls", sheet("Sheet1") firstrow clear
rename Country icountry

save "Temp Pew Religious Composition.dta"


*Pew Religious Freedom 2007-2016
use "Datasets\PublicDataSet_ReligiousRestrictions_2007to2016.dta", clear
rename Ctry_EditorialName icountry
drop GRI* SHI_* GRX*

*merge with Pew Religious Composition
merge m:1 icountry using "Temp Pew Religious Composition.dta"
drop if _merge==2
drop _merge 

rename icountry country
rename Question_Year year

rm "Temp Pew Religious Composition.dta"

outsheet country year SHI pctChristian pctMuslim Region6 using Figure1.csv, comma nolab noquote replace
